<?php
include 'db.php';
date_default_timezone_set('Asia/Jakarta');

$now = date('H:i');
$today = date('Y-m-d');

// Cek SQL querynya berhasil atau gagal
$query = "SELECT * FROM pasaran WHERE waktu_kirim = ? AND aktif = 1 AND (last_sent_date IS NULL OR last_sent_date != ?)";
$stmt = $conn->prepare($query);

if (!$stmt) {
    die("Query error: " . $conn->error);
}

$stmt->bind_param("ss", $now, $today);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $pasaran = $row['name'];

    // Panggil prediksi dari index function atau generate ulang di sini
    $prediksi = generatePrediction($pasaran);

    $pesan =
        "📢 *PREDIKSI " . strtoupper($row['name']) . "* (" . date('d-m-Y') . ")\n\n" .
        "🔢 *BBFS*: " . $prediksi['bbfs'] . "\n" .
        "⭕ *Angka Main*: " . $prediksi['main'] . "\n" .
        "⭕ *Tunggal*: " . $prediksi['tunggal'] . "\n" .
        "💣 *BOM 1 LINE*: " . $prediksi['bom'] . "\n" .
        "⭕ *TOP 2D*: " . $prediksi['angka2d'] . "\n" .
        "⭕ *3D TOP*: " . $prediksi['angka3d'] . "\n" .
        "⭕ *4D TOP*: " . $prediksi['angka4d'] . "\n" .
        "⭕ *Rumus 2D*: " . $prediksi['rumus2d'] . "\n" .
        "🎱 *Shio*: " . $prediksi['shio'] . "\n\n" .
        "💬 Tetap UPS Yah Bosku...!!!\n" .
        "🌐 Link Bet: linkr.it.com/loginkel\n\n" .
        "SALAM JPP";

    $token = "8181084985:AAF0RLfTgM8jGWrI-rU1qyEHI_7w5LqtAqs";
    $chat_id = "5596264808";
    $pesan = urlencode($pesan);
    file_get_contents("https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&text=$pesan&parse_mode=Markdown");

    // Update agar tidak kirim ulang
    $update = $conn->prepare("UPDATE pasaran SET last_sent_date = ? WHERE id = ?");
    $update->bind_param("si", $today, $row['id']);
    $update->execute();
}

function generatePrediction($pasaran) {
    $seed = date("Ymd") . strtolower($pasaran);
    srand(crc32($seed));
    $bbfs = range(0, 9);
    shuffle($bbfs);
    $bbfs = array_slice($bbfs, 0, 6);
    $main = array_slice($bbfs, 0, 3);

    $pairs = [];
    for ($i = 0; $i < count($main); $i++) {
        for ($j = 0; $j < count($main); $j++) {
            if ($i != $j) $pairs[] = $main[$i] . $main[$j];
        }
    }
    shuffle($pairs);
    $angka2d = array_slice($pairs, 0, 6);

    return [
        'bbfs' => implode('', $bbfs),
        'main' => implode(' - ', $main),
        'tunggal' => $main[array_rand($main)],
        'bom' => $pairs[0],
        'angka2d' => implode(' | ', $angka2d),
        'angka3d' => implode(' | ', $angka3d),
        'angka4d' => implode(' | ', $angka4d),
        'rumus2d' => implode(' | ', $rumus2d),
        'shio' => implode(' | ', $shio),
    ];
}
?>