<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin Pasaran</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * { box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 0;
            background: #f5f5f5;
        }
        h2 {
            margin-top: 0;
            color: #333;
        }
        form {
            margin-bottom: 20px;
            background: #fff;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        input[type="text"], input[type="time"], select {
            width: 100%;
            padding: 8px;
            margin: 6px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        button {
            background: #4CAF50;
            color: white;
            border: none;
            padding: 8px 14px;
            margin-top: 8px;
            cursor: pointer;
            border-radius: 4px;
        }
        button:hover {
            background: #45a049;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 10px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }
        img {
            width: 40px;
        }
        @media (max-width: 600px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }
            th {
                display: none;
            }
            td {
                position: relative;
                padding-left: 50%;
                text-align: left;
            }
            td:before {
                position: absolute;
                left: 10px;
                top: 10px;
                font-weight: bold;
                white-space: nowrap;
            }
            td:nth-child(1):before { content: "Nama"; }
            td:nth-child(2):before { content: "Gambar"; }
            td:nth-child(3):before { content: "Waktu Kirim"; }
            td:nth-child(4):before { content: "Aktif"; }
            td:nth-child(5):before { content: "Aksi"; }
        }
    </style>
</head>
<body>

    <h2>Tambah Pasaran</h2>
    <form action="process.php" method="POST">
        <input type="text" name="name" placeholder="Nama Pasaran" required>
        <input type="text" name="flag" placeholder="Link Gambar Bendera" required>
        <input type="time" name="waktu_kirim" required>
        <select name="aktif">
            <option value="1">Aktif</option>
            <option value="0">Nonaktif</option>
        </select>
        <button type="submit" name="add">Tambah</button>
    </form>

    <h2>Daftar Pasaran</h2>
    <table>
        <thead>
            <tr>
                <th>Nama</th>
                <th>Gambar</th>
                <th>Waktu Kirim</th>
                <th>Aktif</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $result = $conn->query("SELECT * FROM pasaran");
        while ($row = $result->fetch_assoc()):
        ?>
            <tr>
                <td><?= htmlspecialchars($row['name']) ?></td>
                <td><img src="<?= $row['flag'] ?>" alt="Flag"></td>
                <td><?= $row['waktu_kirim'] ?></td>
                <td><?= $row['aktif'] ? 'Ya' : 'Tidak' ?></td>
                <td>
                    <form action="process.php" method="POST" style="display:inline-block; margin-bottom:10px;">
                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                        <input type="text" name="name" value="<?= $row['name'] ?>" required>
                        <input type="text" name="flag" value="<?= $row['flag'] ?>" required>
                        <input type="time" name="waktu_kirim" value="<?= $row['waktu_kirim'] ?>" required>
                        <select name="aktif">
                            <option value="1" <?= $row['aktif'] == 1 ? 'selected' : '' ?>>Aktif</option>
                            <option value="0" <?= $row['aktif'] == 0 ? 'selected' : '' ?>>Nonaktif</option>
                        </select><br>
                        <button type="submit" name="edit">Edit</button>
                        <button type="submit" name="delete" onclick="return confirm('Hapus pasaran ini?')">Hapus</button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>

</body>
</html>