<?php
include 'db.php';
date_default_timezone_set('Asia/Jakarta');

header('Content-Type: application/json');

function getShioList() {
    return ["Tikus", "Kerbau", "Macan", "Kelinci", "Naga", "Ular", "Kuda", "Kambing", "Monyet", "Ayam", "Anjing", "Babi"];
}

function getShioHariIni($pasaran) {
    $seed = date("Ymd") . $pasaran;
    srand(crc32($seed));
    $list = getShioList();
    return $list[rand(0, 11)];
}

function generateBBFS($length = 6) {
    $digits = range(0, 9); shuffle($digits);
    return array_slice($digits, 0, $length);
}

function generate2D($bbfs, $count = 6) {
    $pairs = [];
    for ($i = 0; $i < count($bbfs); $i++) {
        for ($j = $i+1; $j < count($bbfs); $j++) {
            $pairs[] = $bbfs[$i] . $bbfs[$j];
            $pairs[] = $bbfs[$j] . $bbfs[$i];
        }
    }
    shuffle($pairs);
    return array_slice(array_unique($pairs), 0, $count);
}

function generateRumus2D($bbfs, $count = 5) {
    $res = [];
    for ($i = 0; $i < count($bbfs) - 1; $i++) {
        $a = ($bbfs[$i] + $bbfs[$i+1]) % 10;
        $b = abs($bbfs[$i] - $bbfs[$i+1]);
        $res[] = "$a$b";
    }
    return array_slice($res, 0, $count);
}

function generateAngkaBom($angka_main) {
    $pairs = [];
    for ($i = 0; $i < count($angka_main); $i++) {
        for ($j = 0; $j < count($angka_main); $j++) {
            if ($i != $j) $pairs[] = $angka_main[$i] . $angka_main[$j];
        }
    }
    shuffle($pairs);
    return $pairs[0];
}

function generate3D($bbfs, $count = 3) {
    $kombinasi = [];
    while (count($kombinasi) < $count) {
        shuffle($bbfs);
        $angka = $bbfs[0] . $bbfs[1] . $bbfs[2];
        if (!in_array($angka, $kombinasi)) {
            $kombinasi[] = $angka;
        }
    }
    return $kombinasi;
}

function generate4D($bbfs, $count = 3) {
    $kombinasi = [];
    while (count($kombinasi) < $count) {
        shuffle($bbfs);
        $angka = $bbfs[0] . $bbfs[1] . $bbfs[2] . $bbfs[3];
        if (!in_array($angka, $kombinasi)) {
            $kombinasi[] = $angka;
        }
    }
    return $kombinasi;
}

function generatePrediction($pasaran) {
    $seed = date("Ymd") . strtolower($pasaran);
    srand(crc32($seed));
    $bbfs = generateBBFS();
    $main = array_slice($bbfs, 0, 3);
    return [
        'bbfs' => implode('', $bbfs),
        'main' => implode(' - ', $main),
        'tunggal' => $main[array_rand($main)],
        'bom' => generateAngkaBom($main),
        'angka2d' => implode(' | ', generate2D($bbfs)),
        'rumus2d' => implode(' | ', generateRumus2D($bbfs)),
        'angka3d' => implode(' | ', generate3D($bbfs)),
        'angka4d' => implode(' | ', generate4D($bbfs)),
        'shio' => getShioHariIni($pasaran)
    ];
}

// Pastikan parameter pasaran dikirim
if (!isset($_GET['pasaran'])) {
    echo json_encode(["status" => "error", "message" => "Parameter 'pasaran' wajib diisi."]);
    exit;
}

$pasaran = $_GET['pasaran'];

// Cek apakah pasaran ada di database
$result = $conn->query("SELECT * FROM pasaran WHERE name = '$pasaran'");

if ($result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Pasaran '$pasaran' tidak ditemukan di database."]);
    exit;
}

// Generate prediksi
$prediksi = generatePrediction($pasaran);

// Output JSON prediksi
echo json_encode($prediksi);
?>